/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.search;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.menu.me.common.GridInventoryEntry;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

final class TagSearchPredicate
implements Predicate<GridInventoryEntry> {
    private final String term;
    private final Map<AEKeyType, List<class_6862<?>>> tagCache = new IdentityHashMap();

    public TagSearchPredicate(String term) {
        this.term = term.toLowerCase(Locale.ROOT);
    }

    private List<class_6862<?>> getTagsMatchingTerm(AEKeyType keyType) {
        return keyType.getTagNames().filter(tagKey -> {
            class_2960 tagId = tagKey.comp_327();
            if (this.term.contains(":")) {
                return tagId.toString().contains(this.term);
            }
            return tagId.method_12836().contains(this.term) || tagId.method_12832().contains(this.term);
        }).toList();
    }

    @Override
    public boolean test(GridInventoryEntry entry) {
        AEKey what = Objects.requireNonNull(entry.getWhat());
        List tags = this.tagCache.computeIfAbsent(what.getType(), this::getTagsMatchingTerm);
        for (class_6862 tag : tags) {
            if (!what.isTagged(tag)) continue;
            return true;
        }
        return false;
    }
}

